function Gamma_rect=SaderHydroRect(rho,eta,omega,W)
%calculates hydrodynamic function for a cantilever of width W, at frequency
%omega, in a medium with density rho and viscosity eta.


for tt=1:7  %omega function coefficients
or1(tt,:)=[0.91324,-0.48274,0.46842,-0.12886,0.044055,-0.0035117,0.00069085]; %real 1
or2(tt,:)=[1,-0.56964,0.4869,-0.13444,0.045155,-0.0035862,0.000698085]; % real 2
oi1(tt,:)=[-0.024134,-0.029256,0.016294,-0.00010961,0.000064577,-0.00004451,0]; % imaginary 1
oi2(tt,:)=[1,-0.59702,0.55182,0.18357,0.079156,-0.014369,0.0028361]; %imaginary 2
end

Re=rho.*omega.*(W.^2)/(4.*eta); %Reynold's number
Gamma_circ=1+((4.*i.*besselk(1,(-i.*sqrt(i.*Re))))./((sqrt(i.*Re).*besselk(0,(-i.*sqrt(i.*Re))))));
tau=log10(Re);
taumatrix=[ones(1,length(omega));tau;tau.^2;tau.^3;tau.^4;tau.^5;tau.^6];
OMEGA=sum(or1*taumatrix)./sum(or2*taumatrix)+ i*sum(oi1*taumatrix)./sum(oi2*taumatrix);
Gamma_rect=OMEGA.*Gamma_circ;